<?php
/**
 * Add theme support for the Gutenberg Editor
 *
 * @package Occasio
 */


/**
 * Registers support for various Gutenberg features.
 *
 * @return void
 */
function occasio_gutenberg_support() {

	// Add theme support for wide and full images.
	add_theme_support( 'align-wide' );

	// Add theme support for dimension controls.
	add_theme_support( 'custom-spacing' );

	// Add theme support for custom line heights.
	add_theme_support( 'custom-line-height' );

	// Define block color palette.
	$color_palette = apply_filters(
		'occasio_color_palette',
		array(
			'primary_color'    => '#2a4861',
			'secondary_color'  => '#5d7b94',
			'tertiary_color'   => '#90aec7',
			'accent_color'     => '#60945d',
			'highlight_color'  => '#915d94',
			'light_gray_color' => '#ededef',
			'gray_color'       => '#84848f',
			'dark_gray_color'  => '#24242f',
		)
	);

	// Add theme support for block color palette.
	add_theme_support(
		'editor-color-palette',
		apply_filters(
			'occasio_editor_color_palette_args',
			array(
				array(
					'name'  => esc_html_x( 'Primary', 'block color', 'occasio' ),
					'slug'  => 'primary',
					'color' => esc_html( $color_palette['primary_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Secondary', 'block color', 'occasio' ),
					'slug'  => 'secondary',
					'color' => esc_html( $color_palette['secondary_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Tertiary', 'block color', 'occasio' ),
					'slug'  => 'tertiary',
					'color' => esc_html( $color_palette['tertiary_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Accent', 'block color', 'occasio' ),
					'slug'  => 'accent',
					'color' => esc_html( $color_palette['accent_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Highlight', 'block color', 'occasio' ),
					'slug'  => 'highlight',
					'color' => esc_html( $color_palette['highlight_color'] ),
				),
				array(
					'name'  => esc_html_x( 'White', 'block color', 'occasio' ),
					'slug'  => 'white',
					'color' => '#ffffff',
				),
				array(
					'name'  => esc_html_x( 'Light Gray', 'block color', 'occasio' ),
					'slug'  => 'light-gray',
					'color' => esc_html( $color_palette['light_gray_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Gray', 'block color', 'occasio' ),
					'slug'  => 'gray',
					'color' => esc_html( $color_palette['gray_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Dark Gray', 'block color', 'occasio' ),
					'slug'  => 'dark-gray',
					'color' => esc_html( $color_palette['dark_gray_color'] ),
				),
				array(
					'name'  => esc_html_x( 'Black', 'block color', 'occasio' ),
					'slug'  => 'black',
					'color' => '#000000',
				),
			)
		)
	);

	// Add theme support for font sizes.
	add_theme_support(
		'editor-font-sizes',
		apply_filters(
			'occasio_editor_font_sizes_args',
			array(
				array(
					'name' => esc_html_x( 'Small', 'block font size', 'occasio' ),
					'size' => 16,
					'slug' => 'small',
				),
				array(
					'name' => esc_html_x( 'Medium', 'block font size', 'occasio' ),
					'size' => 24,
					'slug' => 'medium',
				),
				array(
					'name' => esc_html_x( 'Large', 'block font size', 'occasio' ),
					'size' => 36,
					'slug' => 'large',
				),
				array(
					'name' => esc_html_x( 'Extra Large', 'block font size', 'occasio' ),
					'size' => 48,
					'slug' => 'extra-large',
				),
				array(
					'name' => esc_html_x( 'Huge', 'block font size', 'occasio' ),
					'size' => 64,
					'slug' => 'huge',
				),
			)
		)
	);

	// Check if block style functions are available.
	if ( function_exists( 'register_block_style' ) ) {

		// Register Widget Title Block style.
		register_block_style(
			'core/heading',
			array(
				'name'         => 'widget-title',
				'label'        => esc_html__( 'Widget Title', 'occasio' ),
				'style_handle' => 'occasio-stylesheet',
			)
		);
	}
}
add_action( 'after_setup_theme', 'occasio_gutenberg_support' );


/**
 * Enqueue block styles and scripts for Gutenberg Editor.
 */
function occasio_block_editor_assets() {

	// Get Theme Version.
	$theme_version = wp_get_theme()->get( 'Version' );

	// Enqueue Editor Styling.
	wp_enqueue_style( 'occasio-editor-styles', get_theme_file_uri( '/assets/css/editor-styles.css' ), array(), $theme_version, 'all' );

	// Get current screen.
	$current_screen = get_current_screen();

	// Enqueue Page Template Switcher Editor plugin.
	if ( method_exists( $current_screen, 'is_block_editor' ) && $current_screen->is_block_editor() && 'post' === $current_screen->base ) {
		wp_enqueue_script( 'occasio-page-template-switcher', get_theme_file_uri( '/assets/js/page-template-switcher.js' ), array( 'wp-blocks', 'wp-element', 'wp-edit-post' ), $theme_version );
	}
}
add_action( 'enqueue_block_editor_assets', 'occasio_block_editor_assets' );


/**
 * Add body classes in Gutenberg Editor.
 */
function occasio_block_editor_body_classes( $classes ) {
	global $post;
	$current_screen = get_current_screen();

	// Return early if we are not in the Gutenberg Editor.
	if ( ! ( method_exists( $current_screen, 'is_block_editor' ) && $current_screen->is_block_editor() && 'post' === $current_screen->base ) ) {
		return $classes;
	}

	// Set Theme Layout.
	if ( 'wide' === occasio_get_option( 'theme_layout' ) ) {
		$classes .= ' occasio-wide-theme-layout ';
	} else {
		$classes .= ' occasio-centered-theme-layout ';
	}

	// Fullwidth Page Template?
	if ( 'templates/template-fullwidth.php' === get_page_template_slug( $post->ID ) ) {
		$classes .= ' occasio-fullwidth-page-layout ';
	}

	// No Title Page Template?
	if ( 'templates/template-no-title.php' === get_page_template_slug( $post->ID ) or
		'templates/template-sidebar-left-no-title.php' === get_page_template_slug( $post->ID ) or
		'templates/template-sidebar-right-no-title.php' === get_page_template_slug( $post->ID ) ) {
		$classes .= ' occasio-page-title-hidden ';
	}

	// Full-width / No Title Page Template?
	if ( 'templates/template-fullwidth-no-title.php' === get_page_template_slug( $post->ID ) ) {
		$classes .= ' occasio-fullwidth-page-layout occasio-page-title-hidden ';
	}

	return $classes;
}
add_filter( 'admin_body_class', 'occasio_block_editor_body_classes' );
