<?php
/**
 * The main template file.
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Fasterly
 */

get_header(); 
?>
<section id="post-page" class="post-left-sidebar">
	<div class="container">
		<div class="row">
				<div id="fasterly-pdata" class="<?php esc_attr(fasterly_pages_layout()); ?>">
				<?php 
					$fasterly_paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
					$args = array( 'post_type' => 'post','paged'=>$fasterly_paged );	
				?>
				<?php if( have_posts() ): ?>
					<?php while( have_posts() ) : the_post(); 
							get_template_part('template-parts/content','page'); 
					endwhile; ?>
				<div class="col-12 text-center mt-5">
					<div class="inner-post-pagination">
						 <!-- Pagination -->
							<?php								
								// Previous/next page navigation.
								the_posts_pagination( array(
								'prev_text'       => '<i class="fa fa-angle-double-left"></i>',
								'next_text'       => '<i class="fa fa-angle-double-right"></i>',
								) ); ?>
						<!-- Pagination -->	
					</div>
				</div>
				
				<?php else: ?>
					<?php get_template_part('template-parts/content','none'); ?>
				<?php endif; ?>		
			</div>
			<?php get_sidebar(); ?>
		</div>
	</div>
</section>
<?php get_footer(); ?>
