<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * @package Fasterly
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function fasterly_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}
	return $classes;
}
add_filter( 'body_class', 'fasterly_body_classes' );


/**
 * Function that returns if the menu is sticky
 */
if (!function_exists('fasterly_sticky_menu')):
    function fasterly_sticky_menu()
    {
        $is_sticky = get_theme_mod('hide_show_sticky','1');

        if ($is_sticky == '1'):
            return 'is-sticky-on';
        else:
            return 'sticky-not';
        endif;
    }
endif;


function fasterly_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'fasterly_custom_header_args', array(
		'default-image'          => '',
		'default-text-color'     => 'fff',
		'width'                  => 2000,
		'height'                 => 200,
		'flex-height'            => true,
		'wp-head-callback'       => 'fasterly_header_style',
	) ) );
}
add_action( 'after_setup_theme', 'fasterly_custom_header_setup' );

if ( ! function_exists( 'fasterly_header_style' ) ) :

function fasterly_header_style() {
	$header_text_color = get_header_textcolor();

	?>
	<style type="text/css">
	<?php
		if ( ! display_header_text() ) :
	?>
		.site-title,
		.site-description {
			position: absolute;
			clip: rect(1px, 1px, 1px, 1px);
		}
	<?php
		else :
	?>
		body header h4.site-title,
		body header p.site-description {
			color: #<?php echo esc_attr( $header_text_color ); ?>;
		}
	<?php endif; ?>
	</style>
	<?php
}
endif;


/**
 * Register Google fonts for fasterly.
 */
function fasterly_google_font() {
	
   $font_families = array('Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900');

	$fonts_url = add_query_arg( array(
		'family' => implode( '&family=', $font_families ),
		'display' => 'swap',
	), 'https://fonts.googleapis.com/css2' );

	require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );

	return wptt_get_webfont_url( esc_url_raw( $fonts_url ) );
}

function fasterly_scripts_styles() {
    wp_enqueue_style( 'fasterly-fonts', fasterly_google_font(), array(), null );
}
add_action( 'wp_enqueue_scripts', 'fasterly_scripts_styles' );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */

function fasterly_widgets_init() {	
	register_sidebar( array(
		'name' => __( 'Sidebar Widget Area', 'fasterly' ),
		'id' => 'fasterly-sidebar-primary',
		'description' => __( 'The Primary Widget Area', 'fasterly' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h5 class="widget-title"><span></span>',
		'after_title' => '</h5>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer  1', 'fasterly' ),
		'id' => 'fasterly-footer-1',
		'description' => __( 'The Footer Widget Area 1', 'fasterly' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer  2', 'fasterly' ),
		'id' => 'fasterly-footer-2',
		'description' => __( 'The Footer Widget Area 2', 'fasterly' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'Footer  3', 'fasterly' ),
		'id' => 'fasterly-footer-3',
		'description' => __( 'The Footer Widget Area 3', 'fasterly' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h4 class="widget-title">',
		'after_title' => '</h4>',
	) );
	
	register_sidebar( array(
		'name' => __( 'WooCommerce Widget Area', 'fasterly' ),
		'id' => 'fasterly-woocommerce-sidebar',
		'description' => __( 'This Widget area for WooCommerce Widget', 'fasterly' ),
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget' => '</aside>',
		'before_title' => '<h5 class="widget-title">',
		'after_title' => '</h5>',
	) );
}
add_action( 'widgets_init', 'fasterly_widgets_init' );


// Fasterly Excerpt Read More
if ( ! function_exists( 'fasterly_execerpt_link' ) ) :
function fasterly_execerpt_link() {
	$fasterly_theme_enable_post_btn = get_theme_mod( 'fasterly_theme_enable_post_btn');
	$fasterly_theme_read_btn_txt = get_theme_mod( 'fasterly_theme_read_btn_txt');
	if ( $fasterly_theme_enable_post_btn == '1' ) { 
	?>
	<a href="<?php esc_url(the_permalink()); ?>" class="more-link"><?php echo wp_kses_post($fasterly_theme_read_btn_txt); ?></a>
<?php } 
	} 
endif;

// Custom excerpt length
function fasterly_custom_excerpt_length( $length ) {
	 $fasterly_theme_post_excerpt = get_theme_mod('fasterly_theme_post_excerpt','30');
    if( $fasterly_theme_post_excerpt == 1000 ) {
        return 9999;
    }
    return esc_html( $fasterly_theme_post_excerpt );
}
add_filter( 'excerpt_length', 'fasterly_custom_excerpt_length', 999 );



// excerpt more
function fasterly_excerpt_more( $more ) {
	return get_theme_mod('fasterly_theme_blog_excerpt_more','&hellip;');;
}
add_filter( 'excerpt_more', 'fasterly_excerpt_more' );

if ( ! function_exists( 'wp_body_open' ) ) {
	/**
	 * Backward compatibility for wp_body_open hook.
	 *
	 * @since 1.0.0
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}

if (!function_exists('fasterly_str_replace_assoc')) {

    /**
     * fasterly_str_replace_assoc
     * @param  array $replace
     * @param  array $subject
     * @return array
     */
    function fasterly_str_replace_assoc(array $replace, $subject) {
        return str_replace(array_keys($replace), array_values($replace), $subject);
    }
}

/*==================================================================================
 Fasterly Logo
==================================================================================*/
if ( ! function_exists( 'fasterly_logo_data' ) ) :
function fasterly_logo_data() {
		if(has_custom_logo())
			{	
				the_custom_logo();
			}
			else { 
			?>
			<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="site-title">
				<h4 class="site-title">
					<?php 
						echo esc_html(get_bloginfo('name'));
					?>
				</h4>
			</a>	
		<?php 						
			}
		?>
		<?php
			$fasterly_description = get_bloginfo( 'description');
			if ($fasterly_description) : ?>
				<p class="site-description"><?php echo esc_html($fasterly_description); ?></p>
		<?php endif;
	} 
endif;


if ( ! function_exists( 'fasterly_theme_header_image' ) ) :
function fasterly_theme_header_image() {
	if ( get_header_image() ) : ?>
	<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-header" id="custom-header" rel="home">
		<img src="<?php esc_url(header_image()); ?>" width="<?php echo esc_attr( get_custom_header()->width ); ?>" height="<?php echo esc_attr( get_custom_header()->height ); ?>" alt="<?php echo esc_attr(get_bloginfo( 'title' )); ?>">
	</a>
<?php endif;}endif;




/*==================================================================================
 Fasterly  Header Navigation
==================================================================================*/
if ( ! function_exists( 'fasterly_primary_navigation' ) ) :
function fasterly_primary_navigation() {
	wp_nav_menu( 
		array(  
			'theme_location' => 'primary_menu',
			'container'  => '',
			'menu_class' => 'main-menu menu-effect-2',
			'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
			'walker' => new WP_Bootstrap_Navwalker()
			 ) 
		);
	} 
endif;


/*==================================================================================
 Fasterly Navigation Button
==================================================================================*/
if ( ! function_exists( 'fasterly_nav_button' ) ) :
function fasterly_nav_button() {
	$fasterly_theme_hs_nav_btn 		= get_theme_mod( 'fasterly_theme_hs_nav_btn','1'); 
	$fasterly_theme_nav_btn_lbl 		= get_theme_mod( 'fasterly_theme_nav_btn_lbl');
	$fasterly_theme_nav_btn_link 		= get_theme_mod( 'fasterly_theme_nav_btn_link');
	if($fasterly_theme_hs_nav_btn=='1'  && !empty($fasterly_theme_nav_btn_lbl)):
?>
	<a href="<?php echo esc_url($fasterly_theme_nav_btn_link); ?>" class="btn-1 btn-effect-1 btn-radius-1 hdr-btn"><?php echo wp_kses_post($fasterly_theme_nav_btn_lbl); ?></a>
<?php  endif;
	} 
endif;


/*==================================================================================
 Fasterly  Search
==================================================================================*/
if ( ! function_exists( 'fasterly_navigation_search' ) ) :
function fasterly_navigation_search() {
	$fasterly_theme_hs_search 	= get_theme_mod( 'fasterly_theme_hs_search',''); 
	if($fasterly_theme_hs_search=='1'):	
?>
	<li class="search-button">
		<button id="view-search-btn" class="header-search-toggle"><i class="fa fa-search"></i></button>
		<div class="view-search-btn header-search-popup">
			<div class="search-overlay-layer"></div>
			<div class="header-search-pop">
				<form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>" aria-label="<?php esc_attr_e( 'Site Search', 'fasterly' ); ?>">
					<span class="screen-reader-text"><?php esc_html_e( 'Search for:', 'fasterly' ); ?></span>
					<input type="search" class="search-field header-search-field" placeholder="<?php esc_attr_e( 'Type To Search', 'fasterly' ); ?>" name="s" id="popfocus" value="" autofocus>
					<button type="submit" class="search-submit"><i class="fa fa-search"></i></button>
				</form>
				<button type="button" class="close-style header-search-close"></button>
			</div>
		</div>
	</li>
<?php endif;
	} 
endif;



/*==================================================================================
 Fasterly  Cart
==================================================================================*/
if ( ! function_exists( 'fasterly_navigation_cart' ) ) :
function fasterly_navigation_cart() {
	$fasterly_theme_hs_cart 	= get_theme_mod( 'fasterly_theme_hs_cart','1'); 
		if($fasterly_theme_hs_cart=='1' && class_exists( 'WooCommerce' )):	
	?>
		<li class="header-cart"><a href="<?php echo esc_url(wc_get_cart_url()); ?>"><i class="fa fa-shopping-bag" aria-hidden="true"></i></a>
			<?php 
				$count = WC()->cart->cart_contents_count;	
				if ( $count > 0 ) {
				?>
					 <span class="count cart-counts"><?php echo esc_html( $count ); ?></span>
				<?php 
				}
				else {
					?>
					<span class="count cart-counts"><?php esc_html_e('0','fasterly'); ?></span>
					<?php 
				}
			?>
		</li> 
	<?php endif; 
	} 
endif;
add_action( 'fasterly_navigation_cart', 'fasterly_navigation_cart' );


/*==================================================================================
 Fasterly  Header
==================================================================================*/
if ( ! function_exists( 'fasterly_header_design' ) ) :
function fasterly_header_design() {
	get_template_part('template-parts/site','header');
} 
endif;

 /**
 * Add WooCommerce Cart Icon With Cart Count (https://isabelcastillo.com/woocommerce-cart-icon-count-theme-header)
 */
function fasterly_add_to_cart_fragment( $fragments ) {
	
    ob_start();
    $count = WC()->cart->cart_contents_count;
    ?> 
	<?php
    if ( $count > 0 ) { 
	?>
        <span class="count cart-counts"><?php echo esc_html( $count ); ?></span>
	<?php            
    } else {
	?>	
		<span class="count cart-counts"><?php esc_html_e('0','fasterly'); ?></span>
	<?php
	}
    ?><?php
 
    $fragments['span.cart-counts'] = ob_get_clean();
     
    return $fragments;
}
add_filter( 'woocommerce_add_to_cart_fragments', 'fasterly_add_to_cart_fragment' );
 
/*==================================================================================
 Top Scroller
==================================================================================*/
function fasterly_top_scroller() {
	$fasterly_theme_hs_scroller=get_theme_mod('fasterly_theme_hs_scroller','1');	
	if($fasterly_theme_hs_scroller=='1'): ?>
	<div class="scroll-area">
		<div class="top-wrap">
			<div class="go-top-btn-wraper">
				<div class="go-top go-top-button active">
					<i class="fa fa-arrow-up"></i>
					<i class="fa fa-arrow-up"></i>
				</div>
			</div>
		</div>
	</div>
	<?php endif;	
}
add_action('fasterly_top_scroller','fasterly_top_scroller');



/*==================================================================================
 Fasterly Custom Styles
==================================================================================*/
if( ! function_exists( 'fasterly_theme_output_css' ) ):
    function fasterly_theme_output_css() {
	get_template_part( 'inc/customizer/custom-controls/functions-style' );
		$fasterly_theme_output_css = '';
		
		 /*==================================================================================
		 Breadcrumb
		==================================================================================*/
		$fasterly_theme_breadcrumb_bg_img		= get_theme_mod('fasterly_theme_breadcrumb_bg_img',esc_url(get_template_directory_uri() .'/assets/image/page-title-bg.jpg')); 
		$fasterly_theme_breadcrumb_back_attach	= get_theme_mod('fasterly_theme_breadcrumb_back_attach','scroll'); 
		$fasterly_theme_breadcrumb_bg_img_opacity= get_theme_mod('fasterly_theme_breadcrumb_bg_img_opacity','0.8');
		$fasterly_theme_breadcrumb_overlay_color = get_theme_mod('fasterly_theme_breadcrumb_overlay_color','#000000');
		list($br, $bg, $bb) = sscanf($fasterly_theme_breadcrumb_overlay_color, "#%02x%02x%02x");
		
		if($fasterly_theme_breadcrumb_bg_img !== '') { 
			$fasterly_theme_output_css .=".bd-page-img {
					background: url(" .esc_url($fasterly_theme_breadcrumb_bg_img). ") center center " .esc_attr($fasterly_theme_breadcrumb_back_attach). " rgba($br, $bg, $bb,$fasterly_theme_breadcrumb_bg_img_opacity);
				}\n";
		}else{
			$fasterly_theme_output_css .=".bd-page-img {
				 background: " .esc_attr($fasterly_theme_breadcrumb_overlay_color). ";
			}\n";
		}	
			
		/*==================================================================================
		 Footer
		==================================================================================*/		
		$fasterly_theme_footer_bg_img			= get_theme_mod('fasterly_theme_footer_bg_img',esc_url(get_template_directory_uri() .'/assets/image/footer/footer_bg_2.jpg'));
		$fasterly_theme_footer_bg_overlay_clr	= get_theme_mod('fasterly_theme_footer_bg_overlay_clr','#000000');
		$fasterly_theme_footer_bg_opacity		= get_theme_mod('fasterly_theme_footer_bg_opacity','0.8');		
		list($br, $bg, $bb) = sscanf($fasterly_theme_footer_bg_overlay_clr, "#%02x%02x%02x");	
			$fasterly_theme_output_css .=".footer_bg_img {
					background: url(".esc_url($fasterly_theme_footer_bg_img).") center center fixed rgba($br, $bg, $bb,$fasterly_theme_footer_bg_opacity); 
				}\n";
				
		/*==================================================================================
		 Site Container
		==================================================================================*/
		$fasterly_theme_site_cntnr_width 			 = get_theme_mod('fasterly_theme_site_cntnr_width','1140');
			if($fasterly_theme_site_cntnr_width >=768 && $fasterly_theme_site_cntnr_width <=2000){
				$fasterly_theme_output_css .="@media (min-width: 1200px){.container {
						max-width: " .esc_attr($fasterly_theme_site_cntnr_width). "px;
				}}\n";
			}
			
		/*==================================================================================
		 Background Elements
		==================================================================================*/
		$fasterly_theme_hs_bg_element 	= get_theme_mod('fasterly_theme_hs_bg_element','1');
			if($fasterly_theme_hs_bg_element != '1'){
				$fasterly_theme_output_css .=".bt-shapes-wrap {
						display: none;
				}\n";
			}	
		
        wp_add_inline_style( 'fasterly-style', $fasterly_theme_output_css );
    }
endif;
add_action( 'wp_enqueue_scripts', 'fasterly_theme_output_css' );


/**
 * Theme Page Header Title
*/
function fasterly_page_head_ttl(){
	if( is_archive() )
	{
		echo '<h1 class="bd-ttl">';
		if ( is_day() ) :
		/* translators: %1$s %2$s: date */	
		  printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Archives','fasterly'), get_the_date() );  
        elseif ( is_month() ) :
		/* translators: %1$s %2$s: month */	
		  printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Archives','fasterly'), get_the_date( 'F Y' ) );
        elseif ( is_year() ) :
		/* translators: %1$s %2$s: year */	
		  printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Archives','fasterly'), get_the_date( 'Y' ) );
		elseif( is_author() ):
		/* translators: %1$s %2$s: author */	
			printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('All posts by','fasterly'), get_the_author() );
        elseif( is_category() ):
		/* translators: %1$s %2$s: category */	
			printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Category','fasterly'), single_cat_title( '', false ) );
		elseif( is_tag() ):
		/* translators: %1$s %2$s: tag */	
			printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Tag','fasterly'), single_tag_title( '', false ) );
		elseif( class_exists( 'WooCommerce' ) && is_shop() ):
		/* translators: %1$s %2$s: WooCommerce */	
			printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Shop','fasterly'), single_tag_title( '', false ));
        elseif( is_archive() ): 
		the_archive_title( '<h1 class="bd-ttl">', '</h1>' ); 
		endif;
		echo '</h1>';
	}
	elseif( is_404() )
	{
		echo '<h1 class="bd-ttl">';
		/* translators: %1$s: 404 */	
		printf( esc_html__( '%1$s ', 'fasterly' ) , esc_html__('404','fasterly') );
		echo '</h1>';
	}
	elseif( is_search() )
	{
		echo '<h1 class="bd-ttl">';
		/* translators: %1$s %2$s: search */
		printf( esc_html__( '%1$s %2$s', 'fasterly' ), esc_html__('Search results for','fasterly'), get_search_query() );
		echo '</h1>';
	}
	else
	{
		echo '<h1 class="bd-ttl">'.esc_html( get_the_title() ).'</h1>';
	}
}


/**
 * Theme Breadcrumbs Url
*/
function fasterly_page_url() {
	$page_url = 'http';
	if ( key_exists("HTTPS", $_SERVER) && ( $_SERVER["HTTPS"] == "on" ) ){
		$page_url .= "s";
	}
	$page_url .= "://";
	if ($_SERVER["SERVER_PORT"] != "80") {
		$page_url .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	} else {
		$page_url .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return $page_url;
}


/**
 * Theme Breadcrumbs
*/
if( !function_exists('fasterly_page_head_path') ):
	function fasterly_page_head_path() { 	
		global $post;
		$homeLink = home_url();
								
			if (is_home() || is_front_page()) :
				echo '<li class="bd-item"><a href="'.$homeLink.'">'.__('Home','fasterly').'</a></li>';
	            echo '<li class="bd-item active">'; echo single_post_title(); echo '</li>';
			else:
				echo '<li class="bd-item"><a href="'.$homeLink.'">'.__('Home','fasterly').'</a></li>';
				if ( is_category() ) {
				    echo '<li class="bd-item active"><a href="'. fasterly_page_url() .'">' . __('Archive by category','fasterly').' "' . single_cat_title('', false) . '"</a></li>';
				} elseif ( is_day() ) {
					echo '<li class="bd-item active"><a href="'. get_year_link(get_the_time('Y')) . '">'. get_the_time('Y') .'</a>';
					echo '<li class="bd-item active"><a href="'. get_month_link(get_the_time('Y'),get_the_time('m')) .'">'. get_the_time('F') .'</a>';
					echo '<li class="bd-item active"><a href="'. fasterly_page_url() .'">'. get_the_time('d') .'</a></li>';
				} elseif ( is_month() ) {
					echo '<li class="bd-item active"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>';
					echo '<li class="bd-item active"><a href="'. fasterly_page_url() .'">'. get_the_time('F') .'</a></li>';
				} elseif ( is_year() ) {
				    echo '<li class="bd-item active"><a href="'. fasterly_page_url() .'">'. get_the_time('Y') .'</a></li>';
				} elseif ( is_single() && !is_attachment() && is_page('single-product') ) {					
				if ( get_post_type() != 'post' ) {
					$cat = get_the_category(); 
					$cat = $cat[0];
					echo '<li class="bd-item">';
					echo get_category_parents($cat, TRUE, '');
					echo '</li>';
					echo '<li class="bd-item active"><a href="' . fasterly_page_url() . '">'. get_the_title() .'</a></li>';
				} }  
					elseif ( is_page() && $post->post_parent ) {
				    $parent_id  = $post->post_parent;
					$breadcrumbs = array();
					while ($parent_id) {
						$page = get_page($parent_id);
						$breadcrumbs[] = '<li class="bd-item active"><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
					$parent_id  = $page->post_parent;
					}
					$breadcrumbs = array_reverse($breadcrumbs);
					foreach ($breadcrumbs as $crumb) echo $crumb;
					    echo '<li class="bd-item active"><a href="' . fasterly_page_url() . '">'. get_the_title() .'</a></li>';
                    }
					elseif( is_search() )
					{
					    echo '<li class="bd-item active"><a href="' . fasterly_page_url() . '">'. get_search_query() .'</a></li>';
					}
					elseif( is_404() )
					{
						echo '<li class="bd-item active"><a href="' . fasterly_page_url() . '">'.__('Error 404','fasterly').'</a></li>';
					}
					else { 
					    echo '<li class="bd-item active"><a href="' . fasterly_page_url() . '">'. get_the_title() .'</a></li>';
					}
				endif;
        }
endif;


/**
 * Fasterly Page Title
 */
if ( ! function_exists( 'fasterly_pg_ttl' ) ) {
	function fasterly_pg_ttl() {
		$fasterly_theme_hs_breadcrumb    		  = get_theme_mod('fasterly_theme_hs_breadcrumb','1'); 
		if($fasterly_theme_hs_breadcrumb=='1'):
		?>
		<section id="bd-page-title" class="bd-page-title bd-page-img">
			<div class="container">
				<div class="row">
					<div class="col-lg-12 col-md-12">
						<div class="bd-page-title-content text-center wow fadeInUp">
							<div class="page-title-heading">
								<?php
									if(is_home() || is_front_page()) {
										echo '<h1 class="bd-ttl">'; echo single_post_title(); echo '</h1>';
									} else {
										fasterly_page_head_ttl();
									} 
								?>
							</div>
							<nav class="eb-breadcrumb">
								<ol class="breadcrumb">
									<?php fasterly_page_head_path(); ?>
								</ol>
							</nav>
						</div>
					</div>
				</div>
			</div>
		</section>
		<?php		
		endif; 
	}
}
add_action( 'fasterly_pg_ttl', 'fasterly_pg_ttl' );


/**
 * This Function Check whether Sidebar active or Not
 */
if(!function_exists( 'fasterly_pages_layout' )) :
function fasterly_pages_layout(){
	if(is_active_sidebar('fasterly-sidebar-primary'))
		{ echo 'col-lg-8 col-md-12 col-12'; } 
	else 
		{ echo 'col-lg-12 col-md-12 col-12'; }  
} endif;



/*******************************************************************************
 *  Get Started Notice
 *******************************************************************************/

add_action( 'wp_ajax_fasterly_dismissed_notice_handler', 'fasterly_ajax_notice_handler' );

/**
 * AJAX handler to store the state of dismissible notices.
 */
function fasterly_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        // Pick up the notice "type" - passed via jQuery (the "data-notice" attribute on the notice)
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        // Store it in the options table
        update_option( 'dismissed-' . $type, TRUE );
    }
}

function fasterly_deprecated_hook_admin_notice() {
        // Check if it's been dismissed...
        if ( ! get_option('dismissed-get_started', FALSE ) ) {
            // Added the class "notice-get-started-class" so jQuery pick it up and pass via AJAX,
            // and added "data-notice" attribute in order to track multiple / different notices
            // multiple dismissible notice states ?>
            <div class="updated notice notice-get-started-class is-dismissible" data-notice="get_started">
                <div class="fasterly-getting-started-notice clearfix">
                    <div class="fasterly-theme-screenshot">
                        <img src="<?php echo esc_url( get_stylesheet_directory_uri() ); ?>/screenshot.png" class="screenshot" alt="<?php esc_attr_e( 'Theme Screenshot', 'fasterly' ); ?>" />
                    </div><!-- /.fasterly-theme-screenshot -->
                    <div class="fasterly-theme-notice-content">
                        <h2 class="fasterly-notice-h2">
                            <?php
								printf(
								/* translators: 1: welcome page link starting html tag, 2: welcome page link ending html tag. */
									esc_html__( 'Welcome! Thank you for choosing %1$s!', 'fasterly' ), '<strong>'. wp_get_theme()->get('Name'). '</strong>' );
								?>
                        </h2>

                        <p class="plugin-install-notice"><?php echo sprintf(__('Install and activate <strong>Bunny Companion</strong> plugin for taking full advantage of all the features this theme has to offer.', 'fasterly')) ?></p>

                        <a class="fasterly-btn-get-started button button-primary button-hero fasterly-button-padding" href="#" data-name="" data-slug=""><?php esc_html_e( 'Get started with Fasterly', 'fasterly' ) ?></a><span class="fasterly-push-down">
                        <?php
                            /* translators: %1$s: Anchor link start %2$s: Anchor link end */
                            printf(
                                'or %1$sCustomize theme%2$s</a></span>',
                                '<a target="_blank" href="' . esc_url( admin_url( 'customize.php' ) ) . '">',
                                '</a>'
                            );
                        ?>
                    </div><!-- /.fasterly-theme-notice-content -->
                </div>
            </div>
        <?php }
}

add_action( 'admin_notices', 'fasterly_deprecated_hook_admin_notice' );

/*******************************************************************************
 *  Plugin Installer
 *******************************************************************************/

add_action( 'wp_ajax_install_act_plugin', 'fasterly_admin_install_plugin' );

function fasterly_admin_install_plugin() {
    /**
     * Install Plugin.
     */
    include_once ABSPATH . '/wp-admin/includes/file.php';
    include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    include_once ABSPATH . 'wp-admin/includes/plugin-install.php';

    if ( ! file_exists( WP_PLUGIN_DIR . '/bunny-companion' ) ) {
        $api = plugins_api( 'plugin_information', array(
            'slug'   => sanitize_key( wp_unslash( 'bunny-companion' ) ),
            'fields' => array(
                'sections' => false,
            ),
        ) );

        $skin     = new WP_Ajax_Upgrader_Skin();
        $upgrader = new Plugin_Upgrader( $skin );
        $result   = $upgrader->install( $api->download_link );
    }

    // Activate plugin.
    if ( current_user_can( 'activate_plugin' ) ) {
        $result = activate_plugin( 'bunny-companion/bunny-companion.php' );
    }
}	