<?php
/**
 * Fasterly Theme Customizer.
 *
 */

 if ( ! class_exists( 'Fasterly_Customizer' ) ) {

	/**
	 * Customizer Loader
	 *
	 * @since 1.0.0
	 */
	class Fasterly_Customizer {

		/**
		 * Instance
		 *
		 * @access private
		 * @var object
		 */
		private static $instance;

		/**
		 * Initiator
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self;
			}
			return self::$instance;
		}

		/**
		 * Constructor
		 */
		public function __construct() {
			/**
			 * Customizer
			 */
			add_action( 'customize_preview_init',array( $this, 'fasterly_customize_preview_js' ) );
			add_action( 'customize_controls_enqueue_scripts',array( $this,'fasterly_customizer_script' ) );
			add_action( 'admin_enqueue_scripts',array( $this,'fasterly_admin_enqueue_scripts' ) );
			add_action( 'customize_register',array( $this, 'fasterly_customizer_register' ) );
			add_action( 'after_setup_theme',array( $this, 'fasterly_customizer_settings' ) );
		}
		
		/**
		 * Add postMessage support for site title and description for the Theme Customizer.
		 */
		function fasterly_customizer_register( $wp_customize ) {
			
			$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
			$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
			$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';
			$wp_customize->get_setting( 'background_color' )->transport = 'postMessage';
			$wp_customize->get_setting('custom_logo')->transport = 'refresh';

			/**
			 * Register controls
			 */
			$wp_customize->register_control_type( 'Fasterly_Customizer_Range_Control' );
			
			/**
			 * Helper files
			 */
			 $fasterly_controls = array(
				'fasterly-range-value-control',
				'editor/class/class-fasterly-page-editor',
			);
			foreach ( $fasterly_controls as $control ) {
				require FASTERLY_PARENT_INC_DIR . '/customizer/custom-controls/'.$control.'.php';
			}
			require FASTERLY_PARENT_INC_DIR . '/customizer/sanitization.php';
		}

		/**
		 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
		 */
		function fasterly_customize_preview_js() {
			wp_enqueue_script( 'fasterly-customizer', FASTERLY_PARENT_INC_URI . '/customizer/assets/js/customizer-preview.js', array( 'customize-preview' ), '20151215', true );
		}
		
		function fasterly_customizer_script() {
			 wp_enqueue_script( 'fasterly-customizer-section', FASTERLY_PARENT_INC_URI .'/customizer/assets/js/customizer-section.js', array("jquery"),'', true  );	
		}
		
		//Admin Enqueue for Admin
		function fasterly_admin_enqueue_scripts(){
			wp_enqueue_style('fasterly-admin-style', FASTERLY_PARENT_INC_URI . '/customizer/assets/css/admin.css');
			wp_enqueue_script( 'fasterly-admin-script', FASTERLY_PARENT_INC_URI  . '/customizer/assets/js/fasterly-admin-script.js', array( 'jquery' ), '', true );
			wp_localize_script( 'fasterly-admin-script', 'fasterly_ajax_object',
				array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
			);
		}

		// Include customizer customizer settings.
			
		function fasterly_customizer_settings() {
			$fasterly_settings = array(
				'header',
				'footer',
				'general',
				'plugin-recommendation'
			);
			foreach ( $fasterly_settings as $feature ) {
				require FASTERLY_PARENT_INC_DIR . '/customizer/customizer-options/'.$feature.'.php';
			}
			require FASTERLY_PARENT_INC_DIR . '/customizer/customizer-upsale/class-customize.php';
		}

	}
}

/**
 *  Kicking this off by calling 'get_instance()' method
 */
Fasterly_Customizer::get_instance();