<?php
require get_template_directory() . '/inc/customizer/customizer-options/customizer-notify.php';
$fasterly_config_customizer = array(
	'recommended_plugins'       => array(
		'bunny-companion' => array(
			'recommended' => true,
			'description' => sprintf(__('Install and activate <strong>Bunny Companion</strong> plugin for taking full advantage of all the features this theme has to offer.', 'fasterly')),
		)
	),
	'recommended_actions'       => array(),
	'recommended_actions_title' => esc_html__( 'Recommended Actions', 'fasterly' ),
	'recommended_plugins_title' => esc_html__( 'Recommended Plugin', 'fasterly' ),
	'install_button_label'      => esc_html__( 'Install and Activate', 'fasterly' ),
	'activate_button_label'     => esc_html__( 'Activate', 'fasterly' ),
	'fasterly_deactivate_button_label'   => esc_html__( 'Deactivate', 'fasterly' ),
);
Fasterly_Customizer_Notify::init( apply_filters( 'fasterly_customizer_notify_array', $fasterly_config_customizer ) );



class fasterly_import_dummy_data {

	private static $instance;

	public static function init( ) {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof fasterly_import_dummy_data ) ) {
			self::$instance = new fasterly_import_dummy_data;
			self::$instance->fasterly_setup_actions();
		}

	}

	/**
	 * Setup the class props based on the config array.
	 */
	

	/**
	 * Setup the actions used for this class.
	 */
	public function fasterly_setup_actions() {

		// Enqueue scripts
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'fasterly_import_customize_scripts' ), 0 );

	}
	
	

	public function fasterly_import_customize_scripts() {

	wp_enqueue_script( 'fasterly-import-customizer-js', get_template_directory_uri() . '/inc/customizer/assets/js/import-customizer.js', array( 'customize-controls' ) );
	}
}

$fasterly_import_customizers = array(

		'import_data' => array(
			'recommended' => true,
			
		),
);
fasterly_import_dummy_data::init( apply_filters( 'fasterly_import_customizer', $fasterly_import_customizers ) );