<?php
function fasterly_global_option_data( $wp_customize ) {
$selective_refresh = isset( $wp_customize->selective_refresh ) ? 'postMessage' : 'refresh';
	$wp_customize->add_panel(
		'fasterly_general_options', array(
			'priority' => 31,
			'title' => esc_html__( 'General Options', 'fasterly' ),
		)
	);
	
	/*=========================================
	Top Scroller
	=========================================*/
	$wp_customize->add_section(
		'fasterly_common_options', array(
			'title' => esc_html__( 'Common Options', 'fasterly' ),
			'priority' => 4,
			'panel' => 'fasterly_general_options',
		)
	);
	
	/*=========================================
	Head
	=========================================*/
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_ts_setting_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_ts_setting_head',
		array(
			'type' => 'hidden',
			'label' => __('Top Scroller','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_hs_scroller' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 1,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_hs_scroller', 
		array(
			'label'	      => esc_html__( 'Hide / Show', 'fasterly' ),
			'section'     => 'fasterly_common_options',
			'type'        => 'checkbox'
		) 
	);
	
	/*=========================================
	Background Elements
	=========================================*/
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_bg_element_setting_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_bg_element_setting_head',
		array(
			'type' => 'hidden',
			'label' => __('Background Elements','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_hs_bg_element' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 1,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_hs_bg_element', 
		array(
			'label'	      => esc_html__( 'Hide / Show', 'fasterly' ),
			'section'     => 'fasterly_common_options',
			'type'        => 'checkbox'
		) 
	);
	
	
	/*=========================================
	Fasterly Container
	=========================================*/	
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_ctnr_setting_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_ctnr_setting_head',
		array(
			'type' => 'hidden',
			'label' => __('Site Container','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	if ( class_exists( 'Fasterly_Customizer_Range_Control' ) ) {
		//container width
		$wp_customize->add_setting(
			FASTERLY_THEME_SETTINGS .'_site_cntnr_width',
			array(
				'default'			=> '1140',
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'fasterly_sanitize_range_value',
				'transport'         => 'postMessage',
				'priority'      => 1,
			)
		);
		$wp_customize->add_control( 
		new Fasterly_Customizer_Range_Control( $wp_customize, FASTERLY_THEME_SETTINGS .'_site_cntnr_width', 
			array(
				'label'      => __( 'Container Width', 'fasterly' ),
				'section'  => 'fasterly_common_options',
				 'media_query'   => false,
                'input_attr'    => array(
                    'desktop' => array(
                        'min'           => 768,
                        'max'           => 2000,
                        'step'          => 1,
                        'default_value' => 1140,
                    ),
                ),
			) ) 
		);
	}
	
	
	/*=========================================
	Fasterly Blog
	=========================================*/	
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_blog_rm_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 8,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_blog_rm_head',
		array(
			'type' => 'hidden',
			'label' => __('Blog Options','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	// Enable Date Box
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_db'
			,array(
			'default'     	=> '1',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_db',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Date Box ?','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	// Enable Category
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_cat'
			,array(
			'default'     	=> '1',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_cat',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Post Meta Category ?','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	// Enable Author
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_author'
			,array(
			'default'     	=> '1',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_author',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Post Meta Author ?','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	// Enable Comments
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_comments'
			,array(
			'default'     	=> '1',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_comments',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Post Meta Comments ?','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	
	// Enable Excerpt
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_excerpt'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_excerpt',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Excerpt ?','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	
	// post Exerpt // 
	if ( class_exists( 'Fasterly_Customizer_Range_Control' ) ) {
		$wp_customize->add_setting(
			FASTERLY_THEME_SETTINGS .'_post_excerpt',
			array(
				'default'     	=> '30',
				'capability'     	=> 'edit_theme_options',
				'sanitize_callback' => 'fasterly_sanitize_range_value',
				'priority'      => 10,
			)
		);
		$wp_customize->add_control( 
		new Fasterly_Customizer_Range_Control( $wp_customize, FASTERLY_THEME_SETTINGS .'_post_excerpt', 
			array(
				'label'      => __( 'Excerpt Length', 'fasterly' ),
				'section'  => 'fasterly_common_options',
				 'media_query'   => false,
                'input_attr'    => array(
                    'desktop' => array(
                       'min'           => 0,
                        'max'           => 1000,
                        'step'          => 1,
                        'default_value' => 30,
                    ),
				)	
			) ) 
		);
	}
	
	// excerpt more // 
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS .'_blog_excerpt_more',
    	array(
			'default'      => '...',
			'sanitize_callback' => 'sanitize_text_field',
			'capability' => 'edit_theme_options',
			'priority'      => 11,
		)
	);	

	$wp_customize->add_control( 
		FASTERLY_THEME_SETTINGS .'_blog_excerpt_more',
		array(
		    'label'   => esc_html__('Excerpt More','fasterly'),
		    'section' => 'fasterly_common_options',
			'type' => 'text',
		)  
	);
	
	
	// Enable Excerpt
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_enable_post_btn'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'priority'      => 12,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_enable_post_btn',
		array(
			'type' => 'checkbox',
			'label' => __('Enable Read More Button','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	
	// Readmore button
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_read_btn_txt'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_html',
			'priority'      => 13,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_read_btn_txt',
		array(
			'type' => 'text',
			'label' => __('Read More Button Text','fasterly'),
			'section' => 'fasterly_common_options',
		)
	);
	/*=========================================
	Breadcrumb  Section
	=========================================*/
	$wp_customize->add_section(
		'breadcrumb_setting', array(
			'title' => esc_html__( 'Page Title', 'fasterly' ),
			'priority' => 12,
			'panel' => 'fasterly_general_options',
		)
	);
	
	// Settings
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_breadcrumb_settings'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 1,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_breadcrumb_settings',
		array(
			'type' => 'hidden',
			'label' => __('Settings','fasterly'),
			'section' => 'breadcrumb_setting',
		)
	);
	
	// Breadcrumb Hide/ Show Setting // 
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_hs_breadcrumb' , 
			array(
			'default' => '1',
			'sanitize_callback' => 'fasterly_sanitize_checkbox',
			'capability' => 'edit_theme_options',
			'priority' => 2,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_hs_breadcrumb', 
		array(
			'label'	      => esc_html__( 'Hide / Show Section', 'fasterly' ),
			'section'     => 'breadcrumb_setting',
			'type'        => 'checkbox'
		) 
	);
		
	// Background // 
	$wp_customize->add_setting(
		FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_head'
			,array(
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_text',
			'priority' => 9,
		)
	);

	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_head',
		array(
			'type' => 'hidden',
			'label' => __('Background','fasterly'),
			'section' => 'breadcrumb_setting',
		)
	);
	
	// Background Image // 
    $wp_customize->add_setting( 
    	FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_img' , 
    	array(
			'default' 			=> esc_url(get_template_directory_uri() .'/assets/image/page-title-bg.jpg'),
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_url',	
			'priority' => 10,
		) 
	);
	
	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize , FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_img' ,
		array(
			'label'          => esc_html__( 'Background Image', 'fasterly'),
			'section'        => 'breadcrumb_setting',
		) 
	));
	
	// Background Attachment // 
	$wp_customize->add_setting( 
		FASTERLY_THEME_SETTINGS .'_breadcrumb_back_attach' , 
			array(
			'default' => 'scroll',
			'capability'     => 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_select',
			'priority'  => 10,
		) 
	);
	
	$wp_customize->add_control(
	FASTERLY_THEME_SETTINGS .'_breadcrumb_back_attach' , 
		array(
			'label'          => __( 'Background Attachment', 'fasterly' ),
			'section'        => 'breadcrumb_setting',
			'type'           => 'select',
			'choices'        => 
			array(
				'inherit' => __( 'Inherit', 'fasterly' ),
				'scroll' => __( 'Scroll', 'fasterly' ),
				'fixed'   => __( 'Fixed', 'fasterly' )
			) 
		) 
	);
	
	// Image Opacity // 
	if ( class_exists( 'Fasterly_Customizer_Range_Control' ) ) {
	$wp_customize->add_setting(
    	FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_img_opacity',
    	array(
	        'default'			=> '0.8',
			'capability'     	=> 'edit_theme_options',
			'sanitize_callback' => 'fasterly_sanitize_range_value',
			'priority'  => 11,
		)
	);
	$wp_customize->add_control( 
	new Fasterly_Customizer_Range_Control( $wp_customize, FASTERLY_THEME_SETTINGS .'_breadcrumb_bg_img_opacity', 
		array(
			'label'      => __( 'Opacity', 'fasterly'),
			'section'  => 'breadcrumb_setting',
			'settings' => 'breadcrumb_bg_img_opacity',
			 'media_query'   => false,
                'input_attr'    => array(
                    'desktop' => array(
                        'min'           => 0,
                        'max'           => 1,
                        'step'          => 0.1,
                        'default_value' => 0.8,
                    ),
                ),
		) ) 
	);
	}
	
	$wp_customize->add_setting(
	FASTERLY_THEME_SETTINGS .'_breadcrumb_overlay_color', 
	array(
		'default' => '#000000',
		'capability' => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
		'priority'  => 12,
    ));
	
	$wp_customize->add_control( 
		new WP_Customize_Color_Control
		($wp_customize, 
			FASTERLY_THEME_SETTINGS .'_breadcrumb_overlay_color', 
			array(
				'label'      => __( 'Overlay Color', 'fasterly'),
				'section'    => 'breadcrumb_setting',
			) 
		) 
	);
}
add_action( 'customize_register', 'fasterly_global_option_data' );