<?php
/**
 * The Template Name: Home Page
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * @package Ebooks Collection
 */

get_header(); ?>

<div id="content" >

  <?php
    $ebooks_collection_hidepageboxes = get_theme_mod('ebooks_collection_slider', false);
    $ebooks_collection_catData = get_theme_mod('ebooks_collection_slider_cat');

    if ($ebooks_collection_hidepageboxes && $ebooks_collection_catData) { ?>
    <section id="slider-cat">
        <div class="mainslide">
            <div class="container sliderbox">
                <div class="owl-carousel m-0">
                    <?php
                    $ebooks_collection_page_query = new WP_Query(
                        array(
                            'category_name' => esc_attr($ebooks_collection_catData),
                            'posts_per_page' => -1, 
                        )
                    );
                    while ($ebooks_collection_page_query->have_posts()) : $ebooks_collection_page_query->the_post(); ?>
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-12 align-self-center mb-md-5 mb-2">
                                <div class="text-content">
                                    <h1><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h1>
                                    <?php
                                    $ebooks_collection_trimexcerpt  = get_the_excerpt();
                                    $ebooks_collection_shortexcerpt = wp_trim_words($ebooks_collection_trimexcerpt, $num_words = 30);
                                    echo '<p class="slider-content">' . esc_html($ebooks_collection_shortexcerpt) . '</p>';
                                    ?>
                                    <div class="gap-md-3 d-flex gap-1 text-start mt-4 sliderbtn">
                                        <?php if (get_theme_mod('ebooks_collection_button_text', 'Learn More') != "" || get_theme_mod('ebooks_collection_button_link_slider') != '') { ?>
                                            <div class="slide-btn mb-2">
                                                <a href="<?php echo esc_url(get_theme_mod('ebooks_collection_button_link_slider')!= '') ? esc_url(get_theme_mod('ebooks_collection_button_link_slider')) : esc_url(get_permalink()); ?>"><?php echo esc_html(get_theme_mod('ebooks_collection_button_text', __('Learn More', 'ebooks-collection'))); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('ebooks_collection_button_text', __('Learn More', 'ebooks-collection'))); ?></span></a>
                                            </div>
                                        <?php } ?>
                                        <?php if (get_theme_mod('ebooks_collection_button_text2', 'Shop Now') != "" && get_theme_mod('ebooks_collection_button_link_slider2') != '') { ?>
                                            <div class="slide-btn mb-2">
                                                <a href="<?php echo esc_url(get_theme_mod('ebooks_collection_button_link_slider2', '')); ?>"><?php echo esc_html(get_theme_mod('ebooks_collection_button_text2', __('Shop Now', 'ebooks-collection'))); ?><span class="screen-reader-text"><?php echo esc_html(get_theme_mod('ebooks_collection_button_text2', __('Shop Now', 'ebooks-collection'))); ?></span></a>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6 col-12 align-self-center mb-5">
                                <div class="imagebox">
                                    <?php if(has_post_thumbnail()){
                                      the_post_thumbnail('full');
                                      } else{?>
                                      <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider.png" alt=""/>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </div>
    </section>
  <?php } ?>

  <?php
    $ebooks_collection_hidepageboxes = get_theme_mod('ebooks_collection_disabled_pgboxes',false);
    if( $ebooks_collection_hidepageboxes != ''){
  ?>
  <div id="service-section" class="py-md-5 py-4">
    <div class="container">
      <div class="row">
        <?php if( get_theme_mod('ebooks_collection_service_page',false)) { ?>
          <?php $ebooks_collection_querymed = new WP_query('page_id='.esc_attr(get_theme_mod('ebooks_collection_service_page',false)) ); ?>
            <?php while( $ebooks_collection_querymed->have_posts() ) : $ebooks_collection_querymed->the_post(); ?>
            <div class="col-lg-7 col-md-6"> 
              <div class="text-inner-box pe-lg-5">
                <?php if( get_theme_mod('ebooks_collection_feature_heading') != '' ){ ?>
                  <p class="abt-text mb-0 text-capitalize">
                    <?php echo esc_html(get_theme_mod('ebooks_collection_feature_heading')); ?>
                  </p>
                <?php }?>
                <h2><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <p><?php echo esc_html( wp_trim_words( get_the_content(), 60, '...' ) );  ?></p>
                <div class="abt-btn mt-4">
                  <a href="<?php the_permalink(); ?>"><?php esc_html_e('View All Features','ebooks-collection'); ?></a><span class="screen-reader-text"><?php esc_html_e('View All Features','ebooks-collection'); ?></span>
                </div>
              </div>
            </div>
            <div class="col-lg-5 col-md-6">
              <div class="inner-main-box">
                <?php if( get_theme_mod('ebooks_collection_select_cat_services',false) ) { ?>
                <?php $ebooks_collection_queryvar = new WP_Query('cat='.esc_attr(get_theme_mod('ebooks_collection_select_cat_services',false)));
                  while( $ebooks_collection_queryvar->have_posts() ) : $ebooks_collection_queryvar->the_post(); ?>
                  <div class="row mb-4 m-3 p-md-4 p-3 serv-content">
                    <div class="col-lg-4 col-md-5 align-self-center mb-3">
                      <?php if(has_post_thumbnail()){
                          the_post_thumbnail('full');
                          } else{?>
                          <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/slider.png" alt=""/>
                        <?php } ?>
                    </div>
                    <div class="col-lg-8 col-md-7 align-self-center">
                      <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                      <?php echo esc_html(wp_trim_words( get_the_content(), 10)); ?>
                    </div>
                  </div>
                <?php endwhile; wp_reset_postdata(); ?>
                <?php } ?>
              </div>
            </div>
          <?php endwhile; wp_reset_postdata(); ?>
        <?php }?>
        <div class="clear"></div>
      </div>
    </div>
  </div>
  <?php }?>

</div>
<?php get_footer(); ?>