<?php
/**
 * Upgrade to pro options
 */
function ebooks_collection_upgrade_pro_options( $wp_customize ) {

	$wp_customize->add_section(
		'upgrade_premium',
		array(
			'title'    => esc_html__( 'About Ebook Collection', 'ebooks-collection' ),
			'priority' => 1,
		)
	);

	class Ebooks_Collection_Pro_Button_Customize_Control extends WP_Customize_Control {
		public $type = 'upgrade_premium';

		function render_content() {
			?>
			<div class="pro_info">
				<ul>
					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_THEME_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-admin-appearance"></i><?php esc_html_e( 'Theme Page', 'ebooks-collection' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_SUPPORT ); ?>" target="_blank"><i class="dashicons dashicons-lightbulb"></i><?php esc_html_e( 'Support Forum', 'ebooks-collection' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_REVIEW ); ?>" target="_blank"><i class="dashicons dashicons-star-filled"></i><?php esc_html_e( 'Rate Us', 'ebooks-collection' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_PRO_DEMO ); ?>" target="_blank"><i class="dashicons dashicons-awards"></i><?php esc_html_e( 'Premium Demo', 'ebooks-collection' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_PREMIUM_PAGE ); ?>" target="_blank"><i class="dashicons dashicons-cart"></i><?php esc_html_e( 'Upgrade Pro', 'ebooks-collection' ); ?> </a></li>

					<li><a class="upgrade-to-pro" href="<?php echo esc_url( EBOOK_COLLECTION_THEME_DOCUMENTATION ); ?>" target="_blank"><i class="dashicons dashicons-visibility"></i><?php esc_html_e( 'Theme Documentation', 'ebooks-collection' ); ?> </a></li>

				</ul>
			</div>
			<?php
		}
	}

	$wp_customize->add_setting(
		'pro_info_buttons',
		array(
			'capability'        => 'edit_theme_options',
			'sanitize_callback' => 'ebooks_collection_sanitize_text',
		)
	);

	$wp_customize->add_control(
		new Ebooks_Collection_Pro_Button_Customize_Control(
			$wp_customize,
			'pro_info_buttons',
			array(
				'section' => 'upgrade_premium',
			)
		)
	);
}
add_action( 'customize_register', 'ebooks_collection_upgrade_pro_options' );
