<?php
/**
 * Ebooks Collection Theme Customizer
 *
 * @package Ebooks Collection
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function ebooks_collection_customize_register( $wp_customize ) {

	function ebooks_collection_sanitize_dropdown_pages( $page_id, $setting ) {
  		$page_id = absint( $page_id );
  		return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
	}

	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';

	wp_enqueue_style('ebooks-collection-customize-controls', trailingslashit(esc_url(get_template_directory_uri())).'/css/customize-controls.css');

	//Logo
    $wp_customize->add_setting('ebooks_collection_logo_width',array(
		'default'=> '',
		'transport' => 'refresh',
		'sanitize_callback' => 'ebooks_collection_sanitize_integer'
	));
	$wp_customize->add_control(new Ebooks_Collection_Slider_Custom_Control( $wp_customize, 'ebooks_collection_logo_width',array(
		'label'	=> esc_html__('Logo Width','ebooks-collection'),
		'section'=> 'title_tagline',
		'settings'=>'ebooks_collection_logo_width',
		'input_attrs' => array(
            'step'             => 1,
			'min'              => 0,
			'max'              => 100,
        ),
	)));

	// color site title
	$wp_customize->add_setting('ebooks_collection_sitetitle_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));

	$wp_customize->add_control( 'ebooks_collection_sitetitle_color', array(
	   'settings' => 'ebooks_collection_sitetitle_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Title Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('ebooks_collection_title_enable',array(
		'default' => true,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ebooks_collection_title_enable', array(
	   'settings' => 'ebooks_collection_title_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Title','ebooks-collection'),
	   'type'      => 'checkbox'
	));

	// color site tagline
	$wp_customize->add_setting('ebooks_collection_sitetagline_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_sitetagline_color', array(
	   'settings' => 'ebooks_collection_sitetagline_color',
	   'section'   => 'title_tagline',
	   'label' => __('Site Tagline Color', 'ebooks-collection'),
	   'type'      => 'color'
	));


	$wp_customize->add_setting('ebooks_collection_tagline_enable',array(
		'default' => false,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ebooks_collection_tagline_enable', array(
	   'settings' => 'ebooks_collection_tagline_enable',
	   'section'   => 'title_tagline',
	   'label'     => __('Enable Site Tagline','ebooks-collection'),
	   'type'      => 'checkbox'
	));

	//Theme Options
	$wp_customize->add_panel( 'ebooks_collection_panel_area', array(
		'priority' => 10,
		'capability' => 'edit_theme_options',
		'title' => __( 'Theme Options Panel', 'ebooks-collection' ),
	) );

	//Site Layout Section
	$wp_customize->add_section('ebooks_collection_site_layoutsec',array(
		'title'	=> __('Manage Site Layout Section ','ebooks-collection'),
		'description' => __('<p class="sec-title">Manage Site Layout Section</p>','ebooks-collection'),
		'priority'	=> 1,
		'panel' => 'ebooks_collection_panel_area',
	));

	$wp_customize->add_setting('ebooks_collection_box_layout',array(
		'default' => false,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ebooks_collection_box_layout', array(
	   'section'   => 'ebooks_collection_site_layoutsec',
	   'label'	=> __('Check to Show Box Layout','ebooks-collection'),
	   'type'      => 'checkbox'
 	));

	$wp_customize->add_setting('ebooks_collection_preloader',array(
		'default' => true,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ebooks_collection_preloader', array(
	   'section'   => 'ebooks_collection_site_layoutsec',
	   'label'	=> __('Check to Show preloader','ebooks-collection'),
	   'type'      => 'checkbox'
 	));

 	// Header Section
	$wp_customize->add_section('ebooks_collection_header_section', array(
        'title' => __('Manage Header Section', 'ebooks-collection'),
		'description' => __('<p class="sec-title">Manage Header Section</p>','ebooks-collection'),
        'priority' => null,
		'panel' => 'ebooks_collection_panel_area',
 	));

 	$wp_customize->add_setting('ebooks_collection_stickyheader',array(
		'default' => false,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control( 'ebooks_collection_stickyheader', array(
	   'section'   => 'ebooks_collection_header_section',
	   'label'	=> __('Check To Show Sticky Header','ebooks-collection'),
	   'type'      => 'checkbox'
 	));

	// header menu
	$wp_customize->add_setting('ebooks_collection_menu_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_menu_color', array(
	   'settings' => 'ebooks_collection_menu_color',
	   'section'   => 'ebooks_collection_header_section',
	   'label' => __('Menu Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	// header menu hover color
	$wp_customize->add_setting('ebooks_collection_menuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_menuhrv_color', array(
	   'settings' => 'ebooks_collection_menuhrv_color',
	   'section'   => 'ebooks_collection_header_section',
	   'label' => __('Menu Hover Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	// header sub menu color
	$wp_customize->add_setting('ebooks_collection_submenu_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_submenu_color', array(
	   'settings' => 'ebooks_collection_submenu_color',
	   'section'   => 'ebooks_collection_header_section',
	   'label' => __('SubMenu Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	// header sub menu hover color
	$wp_customize->add_setting('ebooks_collection_submenuhrv_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_submenuhrv_color', array(
	   'settings' => 'ebooks_collection_submenuhrv_color',
	   'section'   => 'ebooks_collection_header_section',
	   'label' => __('SubMenu Hover Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	//Slider
  	$wp_customize->add_section('ebooks_collection_slider_section',array(
	    'title' => __('Manage Slider Section','ebooks-collection'),
	    'priority'  => null,
	    'description'	=> __('<p class="sec-title">Manage Slider Section</p> Select Category from the Dropdowns for slider, Also use the given image dimension (650 x 300).','ebooks-collection'),
	    'panel' => 'ebooks_collection_panel_area',
	));

	$wp_customize->add_setting('ebooks_collection_slider',array(
		'default' => false,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_slider', array(
	   'settings' => 'ebooks_collection_slider',
	   'section'   => 'ebooks_collection_slider_section',
	   'label'     => __('Check To Enable This Section','ebooks-collection'),
	   'type'      => 'checkbox'
	));

	$categories = get_categories();
	$cats = array();
	$i = 0;
	$cat_post[]= 'select';
	foreach($categories as $category){
		if($i==0){
			$default = $category->slug;
			$i++;
		}
		$cat_post[$category->slug] = $category->name;
	}

    $wp_customize->add_setting('ebooks_collection_slider_cat',array(
	    'default' => '0',
	    'sanitize_callback' => 'ebooks_collection_sanitize_choices',
  	));
  	$wp_customize->add_control('ebooks_collection_slider_cat',array(
	    'type'    => 'select',
	    'choices' => $cat_post,
	    'label' => __('Select Category to display Latest Post','ebooks-collection'),
	    'section' => 'ebooks_collection_slider_section',
	));

	$wp_customize->add_setting('ebooks_collection_button_text',array(
		'default' => 'Learn More',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_button_text', array(
	   'settings' => 'ebooks_collection_button_text',
	   'section'   => 'ebooks_collection_slider_section',
	   'label' => __('Add Button Text 1', 'ebooks-collection'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('ebooks_collection_button_link_slider',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('ebooks_collection_button_link_slider',array(
        'label' => esc_html__('Add Button Link 1','ebooks-collection'),
        'section'=> 'ebooks_collection_slider_section',
        'type'=> 'url'
    ));

    $wp_customize->add_setting('ebooks_collection_button_text2',array(
		'default' => 'Shop Now',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_button_text2', array(
	   'settings' => 'ebooks_collection_button_text2',
	   'section'   => 'ebooks_collection_slider_section',
	   'label' => __('Add Button Text 2', 'ebooks-collection'),
	   'type'      => 'text'
	));

	$wp_customize->add_setting('ebooks_collection_button_link_slider2',array(
        'default'=> '',
        'sanitize_callback' => 'esc_url_raw'
    ));
    $wp_customize->add_control('ebooks_collection_button_link_slider2',array(
        'label' => esc_html__('Add Button Link 2','ebooks-collection'),
        'section'=> 'ebooks_collection_slider_section',
        'type'=> 'url'
    ));

    $wp_customize->add_setting( 'ebooks_collection_slider_settings_upgraded_features',array(
    'sanitize_callback' => 'sanitize_text_field'
	));

	$wp_customize->add_control('ebooks_collection_slider_settings_upgraded_features', array(
	    'type'=> 'hidden',
	    'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
	        <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/ebook-store-wordpress-theme/') ." '>Upgrade to Pro</a></span>",
	    'section' => 'ebooks_collection_slider_section'
	));

	// About Section 
	$wp_customize->add_section('ebooks_collection_features_section', array(
		'title'	=> __('Manage Our Features Section','ebooks-collection'),
		'description'	=> __('<p class="sec-title">Manage Our Features Section</p>','ebooks-collection'),
		'priority'	=> null,
		'panel' => 'ebooks_collection_panel_area',
	));
	
	$wp_customize->add_setting('ebooks_collection_disabled_pgboxes',array(
		'default' => false,
		'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_disabled_pgboxes', array(
	   'settings' => 'ebooks_collection_disabled_pgboxes',
	   'section'   => 'ebooks_collection_features_section',
	   'label'     => __('Check To Enable This Section','ebooks-collection'),
	   'type'      => 'checkbox'
	));

	$wp_customize->add_setting('ebooks_collection_feature_heading',array(
		'default' => '',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_feature_heading', array(
	   'settings' => 'ebooks_collection_feature_heading',
	   'section'   => 'ebooks_collection_features_section',
	   'label' => __('Add Small Title', 'ebooks-collection'),
	   'type'      => 'text'
	));
	
	$wp_customize->add_setting('ebooks_collection_service_page',array(
		'default'	=> '0',
		'capability' => 'edit_theme_options',
		'sanitize_callback'	=> 'ebooks_collection_sanitize_dropdown_pages'
	));
	$wp_customize->add_control(	'ebooks_collection_service_page',array(
		'type' => 'dropdown-pages',
	   'label' => __('Select Service Page', 'ebooks-collection'),
		'section' => 'ebooks_collection_features_section',
	));	

	$wp_customize->add_setting( 'ebooks_collection_select_cat_services', array(
		'default'	=> '0',
		'sanitize_callback'	=> 'absint'
	) );
	$wp_customize->add_control( new Ebooks_Collection_Category_Dropdown_Custom_Control( $wp_customize, 'ebooks_collection_select_cat_services', array(
	    'type'    => 'select',
	    'label' => __('Select Category to display Latest Post','ebooks-collection'),
		'section' => 'ebooks_collection_features_section',
		'settings'   => 'ebooks_collection_select_cat_services',
	) ) );

	$wp_customize->add_setting( 'ebooks_collection_secondsec_settings_upgraded_features',array(
    'sanitize_callback' => 'sanitize_text_field'
	));

	$wp_customize->add_control('ebooks_collection_secondsec_settings_upgraded_features', array(
	    'type'=> 'hidden',
	    'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
	        <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/ebook-store-wordpress-theme/') ." '>Upgrade to Pro</a></span>",
	    'section' => 'ebooks_collection_features_section'
	));

	//Blog post
	$wp_customize->add_section('ebooks_collection_blog_post_settings',array(
        'title' => __('Manage Post Section', 'ebooks-collection'),
        'priority' => null,
        'panel' => 'ebooks_collection_panel_area'
    ) );

   // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('ebooks_collection_sidebar_post_layout',array(
     'default' => 'right',
     'sanitize_callback' => 'ebooks_collection_sanitize_choices'
	));
	$wp_customize->add_control('ebooks_collection_sidebar_post_layout',array(
     'type' => 'radio',
     'label'     => __('Theme Post Sidebar Position', 'ebooks-collection'),
     'description'   => __('This option work for blog page, archive page and search page.', 'ebooks-collection'),
     'section' => 'ebooks_collection_blog_post_settings',
     'choices' => array(
         'full' => __('Full','ebooks-collection'),
         'left' => __('Left','ebooks-collection'),
         'right' => __('Right','ebooks-collection'),
         'three-column' => __('Three Columns','ebooks-collection'),
         'four-column' => __('Four Columns','ebooks-collection'),
         'grid' => __('Grid Layout','ebooks-collection')
     ),
	) );

	$wp_customize->add_setting('ebooks_collection_blog_post_description_option',array(
    	'default'   => 'Excerpt Content', 
        'sanitize_callback' => 'ebooks_collection_sanitize_choices'
	));
	$wp_customize->add_control('ebooks_collection_blog_post_description_option',array(
        'type' => 'radio',
        'label' => __('Post Description Length','ebooks-collection'),
        'section' => 'ebooks_collection_blog_post_settings',
        'choices' => array(
            'No Content' => __('No Content','ebooks-collection'),
            'Excerpt Content' => __('Excerpt Content','ebooks-collection'),
            'Full Content' => __('Full Content','ebooks-collection'),
        ),
	) );

	// Footer Section
	$wp_customize->add_section('ebooks_collection_footer', array(
		'title'	=> __('Manage Footer Section','ebooks-collection'),
		'description'	=> __('<p class="sec-title">Manage Footer Section</p>','ebooks-collection'),
		'priority'	=> null,
		'panel' => 'ebooks_collection_panel_area',
	));

	$wp_customize->add_setting('ebooks_collection_footer_widget', array(
	    'default' => false,
	    'sanitize_callback' => 'ebooks_collection_sanitize_checkbox',
	));
	$wp_customize->add_control('ebooks_collection_footer_widget', array(
	    'settings' => 'ebooks_collection_footer_widget', 
	    'section'   => 'ebooks_collection_footer',
	    'label'     => __('Check to Enable Footer Widget', 'ebooks-collection'),
	    'type'      => 'checkbox',
	));

	$wp_customize->add_setting('ebooks_collection_copyright_line',array(
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'ebooks_collection_copyright_line', array(
	   'section' 	=> 'ebooks_collection_footer',
	   'label'	 	=> __('Copyright Line','ebooks-collection'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

    $wp_customize->add_setting('ebooks_collection_copyright_link',array(
    	'default' => 'https://www.theclassictemplates.com/products/free-ebook-wordpress-theme/',
		'sanitize_callback' => 'sanitize_text_field',
	));
	$wp_customize->add_control( 'ebooks_collection_copyright_link', array(
	   'section' 	=> 'ebooks_collection_footer',
	   'label'	 	=> __('Link','ebooks-collection'),
	   'type'    	=> 'text',
	   'priority' 	=> null,
    ));

	//  footer coypright color
	$wp_customize->add_setting('ebooks_collection_footercoypright_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_footercoypright_color', array(
	   'settings' => 'ebooks_collection_footercoypright_color',
	   'section'   => 'ebooks_collection_footer',
	   'label' => __('Coypright Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	//  footer bg color
	$wp_customize->add_setting('ebooks_collection_footerbg_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_footerbg_color', array(
	   'settings' => 'ebooks_collection_footerbg_color',
	   'section'   => 'ebooks_collection_footer',
	   'label' => __('BG Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	//  footer title color
	$wp_customize->add_setting('ebooks_collection_footertitle_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_footertitle_color', array(
	   'settings' => 'ebooks_collection_footertitle_color',
	   'section'   => 'ebooks_collection_footer',
	   'label' => __('Title Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	//  footer description color
	$wp_customize->add_setting('ebooks_collection_footerdescription_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_footerdescription_color', array(
	   'settings' => 'ebooks_collection_footerdescription_color',
	   'section'   => 'ebooks_collection_footer',
	   'label' => __('Description Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	//  footer list color
	$wp_customize->add_setting('ebooks_collection_footerlist_color',array(
		'default' => '',
		'sanitize_callback' => 'ebooks_collection_sanitize_hex_color',
		'capability' => 'edit_theme_options',
	));
	$wp_customize->add_control( 'ebooks_collection_footerlist_color', array(
	   'settings' => 'ebooks_collection_footerlist_color',
	   'section'   => 'ebooks_collection_footer',
	   'label' => __('List Color', 'ebooks-collection'),
	   'type'      => 'color'
	));

	$wp_customize->add_setting('ebooks_collection_scroll_hide', array(
        'default' => false,
        'sanitize_callback' => 'ebooks_collection_sanitize_checkbox'
    ));
    $wp_customize->add_control( new WP_Customize_Control($wp_customize,'ebooks_collection_scroll_hide',array(
        'label'          => __( 'Check To Show Scroll To Top', 'ebooks-collection' ),
        'section'        => 'ebooks_collection_footer',
        'settings'       => 'ebooks_collection_scroll_hide',
        'type'           => 'checkbox',
    )));

    $wp_customize->add_setting( 'ebooks_collection_footer_settings_upgraded_features',array(
    'sanitize_callback' => 'sanitize_text_field'
	));

	$wp_customize->add_control('ebooks_collection_footer_settings_upgraded_features', array(
	    'type'=> 'hidden',
	    'description' => "<span class='customizer-upgraded-features'>Unlock Premium Customization Features:
	        <a target='_blank' href='". esc_url('https://www.theclassictemplates.com/products/ebook-store-wordpress-theme/') ." '>Upgrade to Pro</a></span>",
	    'section' => 'ebooks_collection_footer'
	));

}
add_action( 'customize_register', 'ebooks_collection_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function ebooks_collection_customize_preview_js() {
	wp_enqueue_script( 'ebooks_collection_customizer', esc_url(get_template_directory_uri()) . '/js/customize-preview.js', array( 'customize-preview' ), '20161510', true );
}
add_action( 'customize_preview_init', 'ebooks_collection_customize_preview_js' );
