<?php
/**
 * Ebooks Collection functions and definitions
 *
 * @package Ebooks Collection
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */

if ( ! function_exists( 'ebooks_collection_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which runs
 * before the init hook. The init hook is too late for some features, such as indicating
 * support post thumbnails.
 */
function ebooks_collection_setup() {
	global $ebooks_collection_content_width;
	if ( ! isset( $ebooks_collection_content_width ) )
		$ebooks_collection_content_width = 680;

	load_theme_textdomain( 'ebooks-collection', get_template_directory() . '/languages' );
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( "responsive-embeds" );
	add_theme_support( 'align-wide' );
	add_theme_support( 'woocommerce' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'wp-block-styles');
	add_theme_support( 'custom-header', array(
		'default-text-color' => false,
		'header-text' => false,
	) );
	add_theme_support( 'custom-logo', array(
		'height'      => 100,
		'width'       => 100,
		'flex-height' => true,
	) );
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'ebooks-collection' ),
	) );
	add_theme_support( 'custom-background', array(
		'default-color' => 'ffffff'
	) );
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );

	/*
	 * Enable support for Post Formats.
	 */
	add_theme_support( 'post-formats', array('image','video','gallery','audio',) );

	add_editor_style( 'editor-style.css' );
}
endif; // ebooks_collection_setup
add_action( 'after_setup_theme', 'ebooks_collection_setup' );

function ebooks_collection_the_breadcrumb() {
    echo '<div class="breadcrumb my-3">';

    if (!is_home()) {
        echo '<a class="home-main align-self-center" href="' . esc_url(home_url()) . '">';
        bloginfo('name');
        echo "</a>";

        if (is_category() || is_single()) {
            the_category(' ');
            if (is_single()) {
                echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
            }
        } elseif (is_page()) {
            echo '<span class="current-breadcrumb mx-3">' . esc_html(get_the_title()) . '</span>';
        }
    }

    echo '</div>';
}

function ebooks_collection_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'ebooks-collection' ),
		'description'   => __( 'Appears on blog page sidebar', 'ebooks-collection' ),
		'id'            => 'sidebar-1',
		'before_widget' => '<aside id="%1$s" class="widget %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'ebooks-collection' ),
		'id'            => 'sidebar-2',
		'description'   => __( 'Add widgets here to appear in your sidebar on pages.', 'ebooks-collection' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );

	register_sidebar( array(
		'name'          => __( 'Sidebar 3', 'ebooks-collection' ),
		'id'            => 'sidebar-3',
		'description'   => __( 'Add widgets here to appear in your sidebar on blog posts and archive pages.', 'ebooks-collection' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3>',
	) );
	
	register_sidebar( array(
		'name'          => __( 'Footer Widget 1', 'ebooks-collection' ),
		'description'   => __( 'Appears on footer', 'ebooks-collection' ),
		'id'            => 'footer-1',
		'before_widget' => '<aside id="%1$s" class="ftr-4-box widget-column-1 %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Widget 2', 'ebooks-collection' ),
		'description'   => __( 'Appears on footer', 'ebooks-collection' ),
		'id'            => 'footer-2',
		'before_widget' => '<aside id="%1$s" class="ftr-4-box widget-column-2 %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Widget 3', 'ebooks-collection' ),
		'description'   => __( 'Appears on footer', 'ebooks-collection' ),
		'id'            => 'footer-3',
		'before_widget' => '<aside id="%1$s" class="ftr-4-box widget-column-3 %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => __( 'Footer Widget 4', 'ebooks-collection' ),
		'description'   => __( 'Appears on footer', 'ebooks-collection' ),
		'id'            => 'footer-4',
		'before_widget' => '<aside id="%1$s" class="ftr-4-box widget-column-4 %2$s">',
		'after_widget'  => '</aside>',
		'before_title'  => '<h5>',
		'after_title'   => '</h5>',
	) );
}
add_action( 'widgets_init', 'ebooks_collection_widgets_init' );

function ebooks_collection_scripts() {
	
	wp_enqueue_style( 'bootstrap-css', esc_url(get_template_directory_uri())."/css/bootstrap.css" );
	wp_enqueue_style('ebooks-collection-style', get_stylesheet_uri(), array() );
		wp_style_add_data('ebooks-collection-style', 'rtl', 'replace');

	require get_parent_theme_file_path( '/inc/color-scheme/custom-color-control.php' );
	wp_add_inline_style( 'ebooks-collection-style',$ebooks_collection_color_scheme_css );
	
	wp_enqueue_style( 'owl.carousel-css', esc_url(get_template_directory_uri())."/css/owl.carousel.css" );
	wp_enqueue_style( 'ebooks-collection-default', esc_url(get_template_directory_uri())."/css/default.css" );
	
	wp_enqueue_style( 'ebooks-collection-style', get_stylesheet_uri() );
	wp_enqueue_script( 'owl.carousel-js', esc_url(get_template_directory_uri()). '/js/owl.carousel.js', array('jquery') );
	wp_enqueue_script( 'bootstrap-js', esc_url(get_template_directory_uri()). '/js/bootstrap.js', array('jquery') );
	wp_enqueue_script( 'ebooks-collection-theme', esc_url(get_template_directory_uri()) . '/js/theme.js' );
	wp_enqueue_style( 'font-awesome-css', esc_url(get_template_directory_uri())."/css/fontawesome-all.css" );
	wp_enqueue_style( 'ebooks-collection-block-style', esc_url( get_template_directory_uri() ).'/css/blocks.css' );	

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

	// font-family
	$ebooks_collection_headings_font = esc_html(get_theme_mod('ebooks_collection_headings_fonts'));
	$ebooks_collection_body_font = esc_html(get_theme_mod('ebooks_collection_body_fonts'));

	if ($ebooks_collection_headings_font) {
	    wp_enqueue_style('ebooks-collection-headings-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($ebooks_collection_headings_font));
	} else {
	    wp_enqueue_style('judson-headings', 'https://fonts.googleapis.com/css?family=Judson:ital,wght@0,400;0,700;1,400');
	}

	if ($ebooks_collection_body_font) {
	    wp_enqueue_style('ebooks-collection-body-fonts', 'https://fonts.googleapis.com/css?family=' . urlencode($ebooks_collection_body_font));
	} else {
	    wp_enqueue_style('poppins-body', 'https://fonts.googleapis.com/css?family=Poppins:0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900');
	}
}
add_action( 'wp_enqueue_scripts', 'ebooks_collection_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Sanitization Callbacks.
 */
require get_template_directory() . '/inc/sanitization-callbacks.php';

/**
 * Webfont-Loader.
 */
require get_template_directory() . '/inc/wptt-webfont-loader.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/upgrade-to-pro.php';

/**
 * Theme Info Page.
 */
require get_template_directory() . '/inc/addon.php';

/**
 * select .
 */
require get_template_directory() . '/inc/select/category-dropdown-custom-control.php';
 
/**
 * Theme Info Page.
 */

if ( ! defined( 'EBOOK_COLLECTION_THEME_PAGE' ) ) {
define('EBOOK_COLLECTION_THEME_PAGE',__('https://www.theclassictemplates.com/collections/all','ebooks-collection'));
}
if ( ! defined( 'EBOOK_COLLECTION_SUPPORT' ) ) {
define('EBOOK_COLLECTION_SUPPORT',__('https://wordpress.org/support/theme/ebooks-collection/','ebooks-collection'));
}
if ( ! defined( 'EBOOK_COLLECTION_REVIEW' ) ) {
define('EBOOK_COLLECTION_REVIEW',__('https://wordpress.org/support/theme/ebooks-collection/reviews/#new-post','ebooks-collection'));
}
if ( ! defined( 'EBOOK_COLLECTION_PRO_DEMO' ) ) {
define('EBOOK_COLLECTION_PRO_DEMO',__('https://live.theclassictemplates.com/ebooks-collection-pro/','ebooks-collection'));
}
if ( ! defined( 'EBOOK_COLLECTION_PREMIUM_PAGE' ) ) {
define('EBOOK_COLLECTION_PREMIUM_PAGE',__('https://www.theclassictemplates.com/products/ebook-store-wordpress-theme/','ebooks-collection'));
}
if ( ! defined( 'EBOOK_COLLECTION_THEME_DOCUMENTATION' ) ) {
define('EBOOK_COLLECTION_THEME_DOCUMENTATION',__('https://live.theclassictemplates.com/demo/docs/ebooks-collection-free/','ebooks-collection'));
}

/* Starter Content */
	add_theme_support( 'starter-content', array(
		'widgets' => array(
			'footer-1' => array(
				'categories',
			),
			'footer-2' => array(
				'archives',
			),
			'footer-3' => array(
				'meta',
			),
			'footer-4' => array(
				'search',
			),
		),
    ));

// logo
if ( ! function_exists( 'ebooks_collection_the_custom_logo' ) ) :
/**
 * Displays the optional custom logo.
 *
 * Does nothing if the custom logo is not available.
 *
 */
function ebooks_collection_the_custom_logo() {
	if ( function_exists( 'the_custom_logo' ) ) {
		the_custom_logo();
	}
}
endif;
