<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Ebooks Collection
 */
?>
<div id="footer">
  <?php 
    $ebooks_collection_footer_widget_enabled = get_theme_mod('ebooks_collection_footer_widget', false);
    
    if ($ebooks_collection_footer_widget_enabled !== false && $ebooks_collection_footer_widget_enabled !== '') { ?>

      <div class="footer-widget">
        <div class="container">
          <?php if (!dynamic_sidebar('footer-1')) : ?>
          <?php endif; // end footer widget area ?>
                
          <?php if (!dynamic_sidebar('footer-2')) : ?>
          <?php endif; // end footer widget area ?>
        
          <?php if (!dynamic_sidebar('footer-3')) : ?>
          <?php endif; // end footer widget area ?>
          
          <?php if (!dynamic_sidebar('footer-4')) : ?>
          <?php endif; // end footer widget area ?>
        </div>
      </div>
    <?php } ?>
    <div class="clear"></div>
    
  <div class="copywrap text-center">
    <div class="container">
      <p><a href="<?php echo esc_html(get_theme_mod('ebooks_collection_copyright_link',__('https://www.theclassictemplates.com/products/free-ebook-wordpress-theme/','ebooks-collection'))); ?>" target="_blank"><?php echo esc_html(get_theme_mod('ebooks_collection_copyright_line',__('Ebooks Collection WordPress Theme','ebooks-collection'))); ?></a> <?php echo esc_html('By Classic Templates','ebooks-collection'); ?></p>
    </div>
  </div>
</div>

<?php if(get_theme_mod('ebooks_collection_scroll_hide',false)){ ?>
 <a id="button"><?php esc_html_e('TOP', 'ebooks-collection'); ?></a>
<?php } ?>
  
<?php wp_footer(); ?>
</body>
</html>
