<?php
/**
 * Bunify Theme Setup
 *
 */
function bunify_theme_style() {
	$bunify_parent_style = 'fasterly-style';
	wp_enqueue_style( $bunify_parent_style, get_template_directory_uri() . '/style.css' );
	wp_enqueue_style( 'bunify-style', get_stylesheet_uri(), array( $bunify_parent_style ));
}
add_action( 'wp_enqueue_scripts', 'bunify_theme_style',999);
   	

/*==================================================================================
 Bunify  Header Navigation
==================================================================================*/
if ( ! function_exists( 'bunify_primary_navigation' ) ) :
function bunify_primary_navigation() {
	wp_nav_menu( 
		array(  
			'theme_location' => 'primary_menu',
			'container'  => '',
			'menu_class' => 'main-menu menu-effect-3',
			'fallback_cb' => 'WP_Bootstrap_Navwalker::fallback',
			'walker' => new WP_Bootstrap_Navwalker()
			 ) 
		);
	} 
endif;

/**
 * Remove Customize Panel from parent theme
 */
function bunify_remove_parent_setting( $wp_customize ) {
	$wp_customize->remove_control('fasterly_theme_hdr_social_ttl');
	$wp_customize->remove_control('fasterly_theme_hdr_nav_btn');
	$wp_customize->remove_control('fasterly_theme_hs_nav_btn');
	$wp_customize->remove_control('fasterly_theme_nav_btn_lbl');
	$wp_customize->remove_control('fasterly_theme_nav_btn_link');
	$wp_customize->remove_control('fasterly_theme_footer_copy_head');	
	$wp_customize->remove_control('fasterly_theme_hs_footer_copy');	
	$wp_customize->remove_control('fasterly_theme_footer_s_head');	
	$wp_customize->remove_control('fasterly_theme_hs_footer_social');
	$wp_customize->remove_control('fasterly_theme_footer_social_ttl');	
	$wp_customize->remove_control('fasterly_theme_footer_social_icons');	
}
add_action( 'customize_register', 'bunify_remove_parent_setting',99 );

/**
 * Import Options From Parent Theme
 *
 */
function bunify_parent_theme_options() {
	$fasterly_mods = get_option( 'theme_mods_fasterly' );
	if ( ! empty( $fasterly_mods ) ) {
		foreach ( $fasterly_mods as $fasterly_mod_k => $fasterly_mod_v ) {
			set_theme_mod( $fasterly_mod_k, $fasterly_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'bunify_parent_theme_options' );

require get_stylesheet_directory() . '/inc/customizer/customizer-upsale/class-customize.php';