<?php

/* ------------------------------------------------------------------------------
* Author: web-zone.org
* @package Airin Blog
* Description: Functions for Events Calendar
* ------------------------------------------------------------------------------ */
function airinblog_fun_set_css_events_calendar() {
    //---------- General colors
    // Primary theme color
    $primary_color = esc_attr( get_theme_mod( 'airinblog_cus_colors_primary', '#dd9922' ) );
    // Drawn elements on the main theme color
    $color_lite = esc_attr( get_theme_mod( 'airinblog_cus_colors_primary_lite', '#fffffc' ) );
    //---------- Common colors
    // Heading text general color
    $h_color = '#404046';
    // General text color
    $t_color = '#404040';
    // General link color
    $color_link = '#1e73bb';
    // General link color on hover
    $link_hover = '#dd9925';
    // Site content background color
    $content_color = '#ffffff';
    //---------- Clear
    $css = '';
    //? ========== Style support for The Events Calendar (Customizes the style sheet - Skeleton Styles)
    $opt = tribe_get_option( 'stylesheetOption' );
    if ( $opt == 'skeleton' ) {
        if ( get_theme_mod( 'airinblog_cus_events_calendar_css', 1 ) == 1 ) {
            // Text and links
            $css .= "\n        .tribe-events svg,\n        div.tribe-common .tribe-common-c-svgicon__svg-fill,\n        div.tribe-events .tribe-events-c-events-bar__search-button-icon-svg path,\n        div.tribe-events .tribe-events-calendar-month__day--past .tribe-events-calendar-month__mobile-events-icon--featured .tribe-events-calendar-month__mobile-events-icon-svg path {\n          fill: {$primary_color};\n        }\n        div.tribe-common.tribe-events .tribe-common-c-svgicon,\n        div.tribe-common .tribe-common-h5,\n        div.tribe-common .tribe-common-h6,\n        div.tribe-events-schedule .tribe-events-cost,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-list__event-datetime-featured-text,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-day__event-datetime-featured-text,\n        span.tribe-events-c-small-cta__price,\n        .tribe-block__event-price span.tribe-block__event-price__cost,\n        div.tribe-common .tribe-common-h2,\n        div.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-datetime-featured-text,\n        div.tribe-events .tribe-events-status-label__text,\n        div.tribe-events-single .tribe-events-status-single__header,\n        div.tribe-events-single .tribe-events-status-single__header--alert-icon:before {\n          color: {$primary_color};\n        }\n        div.tribe-common .tribe-common-h7,\n        div.tribe-common .tribe-common-h8,\n        div.tribe-events-schedule h2,\n        h1.tribe-events-single-event-title,\n        div.tribe-events-meta-group .tribe-events-single-section-title,\n        div.tribe-events .tribe-events-calendar-month__day--past h3.tribe-events-calendar-month__day-date,\n        span.tribe-events-calendar-month__header-column-title-desktop,\n        body.single-tribe_events #tribe-events-content.tribe-blocks-editor .tribe-events-event-meta .tribe-events-single-section-title,\n        body.single-tribe_events .tribe-blocks-editor .tribe-events-schedule .tribe-events-schedule__datetime,\n        div.tribe-block__organizer__details h3,\n        body.single-tribe_events .tribe-events-single-event-title,\n        div.tribe-events .tribe-events-calendar-month__header-column-title,\n        .tribe-events-widget-events-list__header h2.tribe-events-widget-events-list__header-title {\n          color: {$h_color};\n        }\n        div.tribe-events-content,\n        div.tribe-events .tribe-common-b2,\n        div.tribe-common .tribe-common-c-svgicon,\n        div.tribe-events .tribe-events-calendar-list__event-datetime,\n        div.tribe-events .tribe-events-calendar-list__event-date-tag-weekday,\n        .single-tribe_events .tribe-events-single .tribe-events-event-meta dl,\n        div.tooltipster-sidetip .tooltipster-content,\n        div.tribe-events .tribe-events-calendar-month__day-date-daynum,\n        div.tribe-events .tribe-events-calendar-day__event-datetime,\n        div.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-datetime,\n        div.tribe-common div.tribe-events-calendar-month__calendar-event-tooltip-description,\n        body.single-tribe_events #tribe-events-content.tribe-blocks-editor .tribe-events-event-meta dl,\n        div.tribe-block__venue .tribe-block__venue__meta .tribe-block__venue__address,\n        div.tribe-block__venue .tribe-block__venue__meta .tribe-block__venue__phone,\n        body.single-tribe_events .tribe-blocks-editor p,\n        span.tribe-events-schedule__all-day,\n        span.tribe-events-schedule__separator,\n        span.tribe-events-schedule__timezone,\n        div.tribe-events-widget .tribe-events-widget-events-list__event-date-tag-month,\n        div.tribe-events-single .tribe-events-status-single__description,\n        div.tribe-block__event-price .tribe-block__event-price__description {\n          color: {$t_color};\n        }\n        div.tribe-common .tribe-common-c-svgicon--messages-not-found path {\n          stroke: {$t_color};\n        }\n        .tribe-events button,\n        div.tribe-common .tribe-common-h3,\n        div.tribe-events button.tribe-events-c-nav__next:disabled,\n        div.tribe-events button.tribe-events-c-nav__prev:disabled,\n        div.tribe-events .tribe-events-calendar-list__event-title-link,\n        div.tribe-events .tribe-events-calendar-list__event-title-link:visited,\n        div.tribe-common .tribe-common-c-btn-icon--caret-right .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common .tribe-common-c-btn-icon--caret-left .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev,\n        div.tribe-events-event-meta a,\n        div.tribe-events-event-meta a:visited,\n        p.tribe-events-back a, \n        p.tribe-events-back a:visited,\n        div.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a,\n        div.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a,\n        div.tribe-events .tribe-events-calendar-month__day--past .tribe-events-calendar-month__day-date-link,\n        div.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link,\n        div.tribe-events .tribe-events-calendar-month__day-date-link,\n        div.tribe-common a:visited,\n        div.tribe-events .tribe-events-calendar-day__event-title-link,\n        div.tribe-events .tribe-events-calendar-day__event-title-link:visited,\n        div.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link,\n        div.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:visited,\n        div.tribe-block__venue .tribe-block__venue__meta .tribe-block__venue__address a,\n        div#tribe-events-content a,\n        div.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link,\n        div.tribe-events .tribe-events-calendar-month-mobile-events__mobile-event-title-link:visited,\n        div.tribe-events .tribe-events-c-messages__message-list-item-link,\n        div.tribe-events .tribe-events-c-nav__list .tribe-common-b2,\n        .tribe-events-widget a.tribe-events-widget-events-list__view-more-link {\n          color: {$color_link};\n        }\n        div.tribe-events button.tribe-events-c-nav__next:disabled .tribe-events-c-nav__next-icon-svg path,\n        div.tribe-events button.tribe-events-c-nav__prev:disabled .tribe-events-c-nav__prev-icon-svg path,\n        div.tribe-common .tribe-common-c-btn-icon--caret-right .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common .tribe-common-c-btn-icon--caret-left .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common .tribe-common-c-btn-icon--caret-right:disabled .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common .tribe-common-c-btn-icon--caret-left:disabled .tribe-common-c-btn-icon__icon-svg path,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev-icon-svg path,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next-icon-svg path {\n          fill: {$color_link};\n        }\n        .tribe-events button:hover\n        div.tribe-common .tribe-common-h3:hover,\n        div.tribe-events .tribe-events-calendar-list__event-title-link:hover,\n        div.tribe-common .tribe-common-c-btn-icon--caret-right .tribe-common-c-btn-icon__icon-svg path:hover,\n        div.tribe-common .tribe-common-c-btn-icon--caret-left .tribe-common-c-btn-icon__icon-svg path:hover,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__next:hover,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-c-nav__prev:hover,\n        div.tribe-events-event-meta a:hover,\n        p.tribe-events-back a:hover,\n        div.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-next a:hover,\n        div.tribe-events-single .tribe-events-sub-nav .tribe-events-nav-previous a:hover,\n        div.tribe-events .tribe-events-calendar-month__day--past .tribe-events-calendar-month__day-date-link:hover,\n        div.tribe-events .tribe-events-calendar-month__day--current .tribe-events-calendar-month__day-date-link:hover,\n        div.tribe-events .tribe-events-calendar-month__day-date-link:hover,\n        div.tribe-common a:visited:hover,\n        div.tribe-events .tribe-events-calendar-day__event-title-link:hover,\n        div.tribe-events .tribe-events-calendar-day__event-title-link:visited:hover,\n        div.tribe-events .tribe-events-calendar-month__calendar-event-tooltip-title-link:hover,\n        div#tribe-events-content a:hover,\n        div.tribe-events .tribe-events-c-messages__message-list-item-link:hover,\n        div.tribe-events .tribe-events-c-nav__list .tribe-common-b2:hover,\n        .tribe-events-widget a.tribe-events-widget-events-list__view-more-link:hover,\n        .tribe-common--breakpoint-full.tribe-events .tribe-events-c-top-bar__datepicker-desktop:hover {\n          color: {$link_hover};\n          opacity: 1;\n        }\n        div.tribe-events .tribe-events-calendar-month__events h3,\n        div.tribe-events-calendar-month__multiday-event-wrapper .tribe-events-status-label__text,\n        div.tribe-events .tribe-events-c-search__input-control-icon-svg path {\n          color: #404040;\n        }\n        .tribe-events .tribe-events-c-search__input-control-icon-svg path {\n          fill: #404040;\n        }\n        div.tribe-events .tribe-events-calendar-month__events h3 {\n          font-weight: normal;\n        }\n        div.tribe-events-calendar-month__multiday-event-wrapper .tribe-events-status-label__text {\n          font-weight: bold;\n        }\n        .tribe-events-c-view-selector__content,\n        div.tribe-common .tribe-common-c-btn-border,\n        div.tribe-common a.tribe-common-c-btn-border,\n        div.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:hover,\n        div.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus,\n        div.tribe-events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__button:focus-within,\n        div.tooltipster-sidetip .tooltipster-box,\n        div.tooltipster-base.tribe-events-tooltip-theme,\n        div.tooltipster-base.tribe-events-tooltip-theme--hover,\n        div.tribe-common a.tribe-common-c-btn-border-small,\n        div.tribe-common a.tribe-common-c-btn-border-small:hover,\n        body.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list {\n          background: {$content_color};\n        }\n        div.tribe-common .tribe-common-c-btn-border,\n        div.tribe-common a.tribe-common-c-btn-border,\n        div.tribe-events-single .tribe-events-status-single {\n          border: 1px solid {$primary_color};\n        }\n        div.tooltipster-box {\n          padding: 15px;\n        }\n        .tooltipster-base.tribe-events-tooltip-theme .tooltipster-box .tooltipster-content,\n        div.tribe-events .tribe-events-calendar-month__events h3 {\n          line-height: 1.2;\n        }\n        div.tribe-events .tribe-events-calendar-month__events h3 {\n          font-size: 1em;\n        }\n        div.tribe-events .tribe-events-calendar-list__month-separator:after,\n        div.tribe-events .tribe-events-calendar-day__type-separator:after,\n        div.tribe-block__event-website a,\n        div.tribe-events .tribe-events-calendar-month__mobile-events-icon--event,\n        .tribe-events button.tribe-events-c-search__button {\n          background: {$primary_color};\n        }\n        div#tribe-events-content .tribe-block__event-website a,\n        .tribe-events button.tribe-events-c-search__button {\n          color: {$color_lite};\n        }\n        div.tribe-events .tribe-events-calendar-list-nav,\n        div.tribe-events-event-meta:before,\n        div#tribe-events-footer,\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__body,\n        div.tribe-events .tribe-events-calendar-day-nav,\n        div.tribe-block__organizer__details,\n        div.tribe-block__venue {\n          border-top: 1px solid {$primary_color};\n        }\n        div.tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__week {\n          border-left: 1px solid {$primary_color};\n        }\n        .tribe-common--breakpoint-medium.tribe-events .tribe-events-calendar-month__day {\n          border-color: {$primary_color};\n        }\n        div.tribe-events .tribe-events-calendar-list__event-row--featured .tribe-events-calendar-list__event-date-tag-datetime:after,\n        div.tribe-events .tribe-events-calendar-day__event--featured:after,\n        div.tribe-events-widget .tribe-events-widget-events-list__event-row--featured .tribe-events-widget-events-list__event-date-tag-datetime:after,\n        div.tribe-events .tribe-events-calendar-month__day-cell--mobile:hover {\n          background: rgba(0,0,0,0.3);\n        }\n        body.single-tribe_events .tribe-events-c-subscribe-dropdown .tribe-events-c-subscribe-dropdown__list-item:hover,\n        div.tribe-events .tribe-events-calendar-month__day-cell--selected,\n        div.tribe-events .tribe-events-calendar-month__day-cell--selected:focus {\n          background: rgba(0,0,0,0.1);\n        }\n        div.tribe-events .tribe-events-c-messages__message {\n          background: rgba(0,0,0,0.03);\n        }\n        .tribe-events button {\n          background: none;\n        }\n        div.tribe-common .tribe-common-c-btn-border {\n          display: flex;\n          align-items: center;\n        }\n        .tribe-block__event-website {\n          margin: 10px 0;\n        }\n        div#tribe-events-content ul.tribe-events-sub-nav {\n          margin-top: 10px;\n        }\n        div.tribe-common.tribe-events .tribe-common-c-svgicon {\n          margin-right: 5px;\n        }\n        .tribe-events .tribe-events-c-messages__message-list-item {\n          margin-left: 10px;\n        }\n        .tribe-events .tribe-events-c-view-selector__content,\n        article.tribe-events-calendar-month__multiday-event {\n          border: 1px solid rgba(0,0,0,0.1);\n        }\n        .tribe-events-widget h2 {\n          font-size: 20px;\n        }\n        .tribe-events-widget h3 {\n          font-size: 18px;\n        }\n        .tribe-events-widget .tribe-common-h2 {\n          font-size: 24px;\n        }\n        @media (min-width: 818px) {\n          button.tribe-common-c-btn.tribe-events-c-search__button {\n            margin-left: 5px;\n            margin-right: 15px;\n          }\n        }\n      ";
        }
        //? ========== Style support for The Events Calendar (Customizes the style sheet - Style default)
    } else {
        if ( $opt == 'tribe' ) {
            // Pages
            $css .= "\n      section#tribe-events-pg-template,\n      div.tribe-common-l-container,\n      div.tribe-events-l-container {\n        background: #f5f5f7;\n      }\n    ";
            // Widgets
            $css .= "\n      .tribe-common.tribe-events-widget .tribe-common-h6 {\n        font-size: 20px;\n      }\n      .tribe-common.tribe-events-widget .tribe-common-h6,\n      .tribe-common.tribe-events-widget .tribe-common-b2,\n      div.tribe-events-widget .tribe-events-widget-events-list__event-date-tag-month {\n        color: inherit;\n      }\n      .tribe-common.tribe-events-widget .tribe-common-h2 {\n        color: {$primary_color};\n      }\n      .tribe-common.tribe-events-widget .tribe-common-c-svgicon--messages-not-found path {\n        stroke: {$primary_color};\n      }\n      .tribe-common.tribe-events-widget a:not(.tribe-common-anchor--unstyle),\n      .tribe-common.tribe-events-widget a:not(.tribe-common-anchor--unstyle):visited {\n        color: {$color_link};\n      }\n      .tribe-common.tribe-events-widget a:not(.tribe-common-anchor--unstyle):hover {\n        color: {$link_hover};\n      }\n    ";
        }
    }
    if ( !empty( $css ) ) {
        wp_add_inline_style( 'airinblog-style-events-calendar', $css );
    }
}

add_action( 'wp_enqueue_scripts', 'airinblog_fun_set_css_events_calendar', 1 );